/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.logger;

import io.gitlab.jfronny.commons.logger.SystemLoggerPlus;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public abstract class LeveledLoggerFinder
extends System.LoggerFinder {
    public static LeveledLoggerFinder get(System.LoggerFinder factory) {
        LeveledLoggerFinder leveledLoggerFinder;
        if (factory instanceof LeveledLoggerFinder) {
            LeveledLoggerFinder fac = (LeveledLoggerFinder)factory;
            leveledLoggerFinder = fac;
        } else {
            leveledLoggerFinder = new DelegatePlatform(factory);
        }
        return leveledLoggerFinder;
    }

    public static LeveledLoggerFinder get(Simple simple) {
        return new DelegateSimple(simple);
    }

    public static LeveledLoggerFinder getLoggerFinder() {
        return LeveledLoggerFinder.get(System.LoggerFinder.getLoggerFinder());
    }

    @Override
    public SystemLoggerPlus getLogger(String s, Module module) {
        return this.getLogger(s, module, null);
    }

    public abstract SystemLoggerPlus getLogger(String var1, Module var2, @Nullable System.Logger.Level var3);

    private static class DelegatePlatform
    extends LeveledLoggerFinder {
        private final System.LoggerFinder delegate;

        private DelegatePlatform(System.LoggerFinder delegate) {
            this.delegate = Objects.requireNonNull(delegate);
        }

        @Override
        public SystemLoggerPlus getLogger(String name, Module module,  @Nullable System.Logger.Level level) {
            return SystemLoggerPlus.get(this.delegate.getLogger(name, module));
        }
    }

    private static class DelegateSimple
    extends LeveledLoggerFinder {
        private final Simple simple;

        private DelegateSimple(Simple simple) {
            this.simple = Objects.requireNonNull(simple);
        }

        @Override
        public SystemLoggerPlus getLogger(String name, Module module,  @Nullable System.Logger.Level level) {
            return this.simple.getLogger(name, module, level);
        }
    }

    @FunctionalInterface
    public static interface Simple {
        public SystemLoggerPlus getLogger(String var1, Module var2, @Nullable System.Logger.Level var3);
    }
}

